# Utworzenie wież A, B i C; Koniec listy reprezentuje szczyt wieży
TOTAL_DISKS = 6

# Wypełnianie wieży A:
TOWERS = {'A': list(reversed(range(1, TOTAL_DISKS + 1))),
          'B': [],
          'C': []}

def printDisk(diskNum):
    # Wyświetlanie pojedynczego krążka o szerokości diskNum
    emptySpace = ' ' * (TOTAL_DISKS - diskNum)
    if diskNum == 0:
        # Rysowanie słupka.
        print(emptySpace + '||' + emptySpace, end='')
    else:
        # Rysowanie krążka.
        diskSpace = '@' * diskNum
        diskNumLabel = str(diskNum).rjust(2, '_')
        print(emptySpace + diskSpace + diskNumLabel + diskSpace + emptySpace, end='')

def printTowers():
    # Wyświetlanie wszystkich trzech wież
    for level in range(TOTAL_DISKS, -1, -1):
        for tower in (TOWERS['A'], TOWERS['B'], TOWERS['C']):
            if level >= len(tower):
                printDisk(0)
            else:
                printDisk(tower[level])
        print()
    # Wyświetlanie etykiet wież
    emptySpace = ' ' * (TOTAL_DISKS)
    print('%s A%s%s B%s%s C\n' % (emptySpace, emptySpace, emptySpace, emptySpace, emptySpace))

def moveOneDisk(startTower, endTower):
    # Przeniesienie szczytowego krążka ze startTower do endTower
    disk = TOWERS[startTower].pop()
    TOWERS[endTower].append(disk)

def solve(numberOfDisks, startTower, endTower, tempTower):
    # Przeniesienie pierwszych numberOfDisks krążków ze startTower do endTower
    if numberOfDisks == 1:
        # PRZYPADEK BAZOWY
        moveOneDisk(startTower, endTower)
        printTowers()
        return
    else:
        # PRZYPADEK REKURENCYJNY
        solve(numberOfDisks - 1, startTower, tempTower, endTower)
        moveOneDisk(startTower, endTower)
        printTowers()
        solve(numberOfDisks - 1, tempTower, endTower, startTower)
        return


# Rozwiązywanie
printTowers()
solve(TOTAL_DISKS, 'A', 'B', 'C')

# Odkomentuj, aby uruchomić tryb interaktywny:
#while True:
#    printTowers()
#    print('Wpisz litery reprezentujące początkową i końcową wieżę (A, B, C) lub Q, aby zakończyć')
#    move = input().upper()
#    if move == 'Q':
#        sys.exit()
#    elif move[0] in 'ABC' and move[1] in 'ABC' and move[0] != move[1]:
#        moveOneDisk(move[0], move[1])

